//Experiment No.8
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at    
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//This Source file is Written by Dr. T. Subbulaskhmi, Professor, 
//School of Computing Science and Engineering, VIT University Chennai 
//using the NARVAL examples of Scilab for Network Topology Creation  
//The Operating System used for writing the code found in this file is Windows 8
//SCILAB version 5.5.2 and NARVAL toolbox version 3.1//This Program is Written by Souarv kumar Surya(15bce1364),Prayag Bhatia (15bce1363),Maaz Ahmed (15bce1261), School of Computing Science and Engineering, VIT University Chennai using the NARVAL examples of Scilab for finding the shortest path 
//This is the scilab code to find the Shortest path from source to destination in Star topology network using flood for 10 nodes. 
clear;
clc;

NameOfNetwork='star network with 10 node';// graph name
NumberOfNodes=10;//no of nodes
//every edge has head and tail.
EndingNodesOfConnection=[6 6 6 6 6 6 6 6 6 ];// tail of eatch edge, this is a node from a edge or link is originating 
StartNodesOfConnection=[1 2 3 4 5 7 8 9 10];//head of each edge,this is a node where edge or link is terminating 
// so, an edge can be represent as (tail,head),tail and head both are node no. eg.:   tail[1]=6,head[1]=1 means edge 1 is originating from 6 and terminating on 1 that implies there is an edge betweem node 1 and   node 2
XCoordinatesOfNodes=[100 400 100 700 850 500 300 500 400 600];// x-coordinate of each node
YCoordinatesOfNodes=[100 100 400 400 500 500 200 300 500 600];//y-coordinate of each node
//node i can represent as node_x[i],node_y[i]
[TopologyGraph]=NL_G_MakeGraph(NameOfNetwork,NumberOfNodes,EndingNodesOfConnection,StartNodesOfConnection,XCoordinatesOfNodes,YCoordinatesOfNodes)//application of NL_G_MakeGraph
NetworkSize=length(TopologyGraph.node_x);//real network size
NetworkQuantity=length(TopologyGraph.head);//quantity of network links
[Node1,Node2]=NL_F_RandIntNiNj(NetworkSize)//selection of two distinct nodes
TimeToLive=15;//Time-To-Live update
[path]=NL_R_Flood(TopologyGraph,Node1,Node2,TimeToLive)//application of NL_R_Flood
ShortestPath=NL_G_Nodes2Path(path,TopologyGraph);//links of the shortest path
EdgeColor=ones(1,NetworkQuantity);//display the path between i and j: edge color
EdgeBorder=1.5*ones(1,NetworkQuantity);//edge width
EdgeColor(ShortestPath)=5;//define path color
EdgeBorder(ShortestPath)=5;//define width 
NodeBorder=4*ones(1,NetworkSize);//node border
NodeBorder(path)=10;//node border for source to destination path
TopologyGraph.node_border=NodeBorder;//node border
TopologyGraph.edge_color=EdgeColor;//define edge color
TopologyGraph.edge_width=EdgeBorder;//edge width
WindowNumber=1;//window index
GraphVisualize=NL_G_ShowGraphN(TopologyGraph,WindowNumber);//graph visualization

xtitle("Shortest path in Star Topology network using flood for 12 nodes","X-Nodes","Y-Nodes");

//This is the scilab code to find the Shortest path from source to destination in Star topology network using flood for 30 nodes. 

NameOfNetwork='star network with 30 node';// graph name
NumberOfNodes=30;//no of nodes
//every edge has head and tail.
EndingNodesOfConnection=[6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6];// tail of eatch edge, this is a node from a edge or link is originating 
StartNodesOfConnection=[1 2 3 4 5 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30];//head of each edge,this is a node where edge or link is terminating 
// so, an edge can be represent as (tail,head),tail and head both are node no. eg.:   tail[1]=6,head[1]=1 means edge 1 is originating from 6 and terminating on 1 that implies there is an edge betweem node 1 and   node 2
XCoordinatesOfNodes=[100 400 100 700 850 500 300 500 400 600 300 200 500 400 700 800 900 850 950 450 550 650 350 250 150 725 825 925 300 650];// x-coordinate of each node
YCoordinatesOfNodes=[200 100 400 400 500 500 200 300 500 600 250 350 700 300 200 500 400 600 700 700 350 550 450 235 750 100 353 770 400 950];//y-coordinate of each node
//node i can represent as node_x[i],node_y[i]
[TopologyGraph]=NL_G_MakeGraph(NameOfNetwork,NumberOfNodes,EndingNodesOfConnection,StartNodesOfConnection,XCoordinatesOfNodes,YCoordinatesOfNodes)//application of NL_G_MakeGraph
NetworkSize=length(TopologyGraph.node_x);//real network size
NetworkQuantity=length(TopologyGraph.head);//quantity of network links
[Node1,Node2]=NL_F_RandIntNiNj(NetworkSize)//selection of two distinct nodes
TTL=15;//Time-To-Live update
[path]=NL_R_Flood(TopologyGraph,Node1,Node2,TTL)//application of NL_R_Flood
ShortestPath=NL_G_Nodes2Path(path,TopologyGraph);//links of the shortest path
EdgeColor=ones(1,NetworkQuantity);//display the path between i and j: edge color
EdgeBorder=1.5*ones(1,NetworkQuantity);//edge width
EdgeColor(ShortestPath)=5;//define path color
EdgeBorder(ShortestPath)=5;//define width 
NodeBorder=4*ones(1,NetworkSize);//node border
NodeBorder(path)=10;//node border for source to destination path
TopologyGraph.node_border=NodeBorder;//node border
TopologyGraph.edge_color=EdgeColor;//define edge color
TopologyGraph.edge_width=EdgeBorder;//edge width
WindowNumber=2;//window index
GraphVisualize=NL_G_ShowGraphN(TopologyGraph,WindowNumber);//graph visualization
xtitle("Shortest path in star Topology network using flood for 30 nodes","X-Nodes","Y-Nodes");
